//
//  CSMailClient.h
//  CSMail
//
//  Created by Alastair Houghton on 07/01/2006.
//  Copyright 2006 Coriolis Systems Limited. All rights reserved.
//

#import <Cocoa/Cocoa.h>

enum {
  kCSMCMessageDispatchFeature	  = 0x0001,
  kCSMCMessageConstructionFeature = 0x0002,
  kCSMCConfigureFeature		  = 0x0004,
  kCSMCNeedsEmailAddressFeature	  = 0x0008,
  // If not set, the client must be used on the main thread
  kCSMCCanRunOnThreadFeature	  = 0x0010,
};

@interface CSMailClient : NSObject
{
}

+ (NSArray *)installedClients;
+ (void)loadAllPluginsAtPath:(NSString *)path;

- (NSString *)name;
- (NSString *)version;

- (NSString *)applicationName;
- (NSImage *)applicationIcon;
- (NSString *)displayName;

- (int)features;
- (BOOL)supportsFeature:(int)feature;

- (BOOL)applicationIsInstalled;

- (BOOL)deliverMessage:(NSAttributedString *)messageBody
	       headers:(NSDictionary *)messageHeaders;
- (BOOL)constructMessage:(NSAttributedString *)messageBody
		 headers:(NSDictionary *)messageHeaders;
- (BOOL)deliverMessage:(NSAttributedString *)messageBody
	       headers:(NSDictionary *)messageHeaders
		 error:(NSError **)error;
- (BOOL)constructMessage:(NSAttributedString *)messageBody
		 headers:(NSDictionary *)messageHeaders
		   error:(NSError **)error;
- (void)configure:(id)sender;

+ (void)setDefaultClient:(CSMailClient *)mc;
+ (CSMailClient *)defaultClient;
+ (CSMailClient *)mailClient;
+ (BOOL)setDefaultClientFromName:(NSString *)theName;
+ (CSMailClient *)mailClientFromName:(NSString *)theName;

@end

@interface NSObject (CSMailClientPlugin)

- (NSString *)applicationBundleIdentifier;

@end

extern NSString *CSMailPlugInsDidLoadNotification;
extern NSString *CSMailErrorDomain /* = @"CSMailErrorDomain" */;

enum {
  CSMailUnspecifiedError = 1
};

/*
 * Local Variables:
 * mode: objc
 * End Local Variables:
 *
 */
